<?php

namespace RTMCustomMails\Preview;

use RTMCustomMails\Email\DynamicEmail;
use RTMCustomMails\Email\RTMCustomEmail;
use WC_Email;
use WC_Emails;
use WordpressModels\Traits\SingletonTrait;

/**
 *
 */
class PreviewEmails
{

    use SingletonTrait;

    /**
     * Return an instance of this class.
     *
     * @return object A single instance of this class.
     */
    private array $emails = [];
    private ?string $notice_message = null;
    private ?string $notice_class = null;

    public function __construct()
    {
        add_action('woocommerce_email', [$this, 'load'], 999);
        add_filter('wrce_filter_allowed_preview_emails', [$this, 'getAllowedPreviewEmails']);

        EmailObjects::instance();
    }

    /**
     * @param $emails
     * @return mixed
     */
    public function getAllowedPreviewEmails($emails): mixed
    {
        $disallowed_previews = apply_filters('wrce_disallow_preview_email_types', []);

        foreach ($disallowed_previews as $disallowed_preview) {
            if (isset($emails[$disallowed_preview])) {
                unset($emails[$disallowed_preview]);
            }
        }

        return $emails;
    }

    public function load(WC_Emails $emails): void
    {
        $this->emails = apply_filters('wrce_filter_allowed_preview_emails', $emails->get_emails());
    }

    /**
     * @param $recipient
     * @return string
     */
    public static function noRecipient($recipient): string
    {
        return '';
    }

    public function renderEmail(string $emailType, int $itemId, WC_Email $currentEmail): string
    {
        $this->setupEmailContext($emailType, $itemId, $currentEmail);
        return apply_filters('woocommerce_mail_content', $currentEmail->style_inline($currentEmail->get_content_html()));
    }

    /**
     * @param string $emailType
     * @param int $itemId
     * @param WC_Email $currentEmail
     * @return array
     */
    public static function setupEmailContext(string $emailType, int $itemId, WC_Email $currentEmail): array
    {
        $currentEmail = RTMCustomEmail::asCustomEmail($currentEmail);
        $triggerArgs = apply_filters('wrce_preview_trigger_args', false, $emailType, $itemId, $currentEmail);

        // disable recipient and allow resend new order email
        add_filter('woocommerce_email_recipient_' . $currentEmail->id, [self::class, 'noRecipient']);
        add_filter('woocommerce_new_order_email_allows_resend', '__return_true');

        if ($triggerArgs) {
            if ($currentEmail instanceof DynamicEmail) {
                call_user_func([$currentEmail, 'trigger'], ...array_values($triggerArgs));
            } else if (is_array($triggerArgs)) {
                if (!array_is_list($triggerArgs)) {
                    call_user_func_array([$currentEmail, 'trigger'], $triggerArgs);
                } else {
                    call_user_func([$currentEmail, 'trigger'], ...$triggerArgs);
                }
            } else {
                call_user_func([$currentEmail, 'trigger'], $triggerArgs);
            }
        } else {
            $currentEmail->trigger($itemId);
        }

        // reenable recipient and allow resend new order email
        remove_filter('woocommerce_email_recipient_' . $currentEmail->id, [self::class, 'noRecipient']);
        remove_filter('woocommerce_new_order_email_allows_resend', '__return_true');

        return $currentEmail->getRenderContext();
    }

}