<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Symfony\Bundle\FrameworkBundle\Console\Helper;

use WRCE\Dependencies\Symfony\Bundle\FrameworkBundle\Console\Descriptor\JsonDescriptor;
use WRCE\Dependencies\Symfony\Bundle\FrameworkBundle\Console\Descriptor\MarkdownDescriptor;
use WRCE\Dependencies\Symfony\Bundle\FrameworkBundle\Console\Descriptor\TextDescriptor;
use WRCE\Dependencies\Symfony\Bundle\FrameworkBundle\Console\Descriptor\XmlDescriptor;
use WRCE\Dependencies\Symfony\Component\Console\Helper\DescriptorHelper as BaseDescriptorHelper;
use WRCE\Dependencies\Symfony\Component\ErrorHandler\ErrorRenderer\FileLinkFormatter;

/**
 * @author Jean-François Simon <jeanfrancois.simon@sensiolabs.com>
 *
 * @internal
 */
class DescriptorHelper extends BaseDescriptorHelper
{
    public function __construct(?FileLinkFormatter $fileLinkFormatter = null)
    {
        $this
            ->register('txt', new TextDescriptor($fileLinkFormatter))
            ->register('xml', new XmlDescriptor())
            ->register('json', new JsonDescriptor())
            ->register('md', new MarkdownDescriptor())
        ;
    }
}
