<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Symfony\Bridge\Doctrine\DataFixtures;

use WRCE\Dependencies\Doctrine\Common\DataFixtures\FixtureInterface;
use WRCE\Dependencies\Doctrine\Common\DataFixtures\Loader;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\ContainerAwareInterface;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\ContainerInterface;

trigger_deprecation('symfony/dependency-injection', '6.4', '"%s" is deprecated, use dependency injection in your fixtures instead.', ContainerAwareLoader::class);

/**
 * Doctrine data fixtures loader that injects the service container into
 * fixture objects that implement ContainerAwareInterface.
 *
 * Note: Use of this class requires the Doctrine data fixtures extension, which
 * is a suggested dependency for Symfony.
 *
 * @deprecated since Symfony 6.4, use dependency injection in your fixtures instead
 */
class ContainerAwareLoader extends Loader
{
    public function __construct(
        private readonly ContainerInterface $container,
    ) {
    }

    /**
     * @return void
     */
    public function addFixture(FixtureInterface $fixture)
    {
        if ($fixture instanceof ContainerAwareInterface) {
            $fixture->setContainer($this->container);
        }

        parent::addFixture($fixture);
    }
}
