<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\Rest\Permissions;

use WRCE\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionLanguage;
use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;

class PermissionExpressionLanguage
{

    use SingletonTrait;

    private readonly ExpressionLanguage $language;

    public function __construct(
        private readonly PermissionFunctionsInterface $permissionFunctions = new WordpressPermissionFunctions()
    )
    {
        $this->language = new ExpressionLanguage(null,
            [
                new RoleExpressionFunctionProvider($permissionFunctions),
                new AuthorizationExpressionFunctionProvider($permissionFunctions),
                new CapabilityExpressionFunctionProvider($permissionFunctions)
            ]);
    }

    public function evaluate(string $expression, array $routeParams)
    {
        return $this->language->evaluate($expression, $routeParams);
    }

    public function getLanguage(): ExpressionLanguage
    {
        return $this->language;
    }

}