<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM;

use WRCE\Dependencies\Doctrine\DBAL\Driver\AbstractMySQLDriver;
use WRCE\Dependencies\Doctrine\DBAL\Driver\Mysqli\Connection;
use ReflectionClass;
use wpdb;

class WpdbDriver extends AbstractMySQLDriver
{
    /**
     * Get the `wpdb::$dhb` property and use it as the MySQL Connection constructor parameter.
     * @param array $params
     * @return Connection
     * @throws \WRCE\Dependencies\Doctrine\DBAL\Exception
     */
    public function connect(array $params): Connection
    {
        global $wpdb;

        $reflectionClass = new ReflectionClass(wpdb::class);
        $property = $reflectionClass->getProperty('dbh');
        $property->setAccessible(true);
        $mysqli = $property->getValue($wpdb);

        return new Connection($mysqli);
    }
}
