<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Column;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Entity;
use WRCE\Dependencies\Doctrine\ORM\Mapping\GeneratedValue;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Id;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Table;

/**
 * Doctrine entity matching the wp_woocommerce_shipping_zones table.
 *
 * Schema:
 * ```sql
 * create table wp_woocommerce_shipping_zones
 * (
 * zone_id    bigint unsigned auto_increment
 * primary key,
 * zone_name  varchar(200)    not null,
 * zone_order bigint unsigned not null
 * )
 * ```
 */
#[Entity]
#[Table(name: 'shipping_zones')]
class ShippingZone
{

    #[Id]
    #[Column(name: 'zone_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[Column(name: 'zone_name', type: Types::STRING, length: 200)]
    private string $name;

    #[Column(name: 'zone_order', type: Types::BIGINT, options: ['unsigned' => true])]
    private int $order;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return ShippingZone
     */
    public function setId(?int $id): ShippingZone
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ShippingZone
     */
    public function setName(string $name): ShippingZone
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getOrder(): int
    {
        return $this->order;
    }

    /**
     * @param int $order
     * @return ShippingZone
     */
    public function setOrder(int $order): ShippingZone
    {
        $this->order = $order;
        return $this;
    }

}