<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\ORM\Mapping\Entity;
use WRCE\Dependencies\Doctrine\ORM\Mapping\JoinColumn;
use WRCE\Dependencies\Doctrine\ORM\Mapping\ManyToOne;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Table;
use WRCE\Dependencies\WordpressModels\ORM\Entity\AbstractMeta;

#[Entity]
#[Table(name: 'payment_tokenmeta')]
class PaymentTokenMeta extends AbstractMeta
{

    #[ManyToOne(targetEntity: PaymentToken::class)]
    #[JoinColumn(name: 'payment_token_id', referencedColumnName: 'token_id')]
    private PaymentToken $paymentToken;

    /**
     * @return PaymentToken
     */
    public function getPaymentToken(): PaymentToken
    {
        return $this->paymentToken;
    }

    /**
     * @param PaymentToken $paymentToken
     * @return PaymentTokenMeta
     */
    public function setPaymentToken(PaymentToken $paymentToken): PaymentTokenMeta
    {
        $this->paymentToken = $paymentToken;
        return $this;
    }

    public static function getType(): string
    {
        return 'payment_token';
    }

}