<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;


use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Column;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Entity;
use WRCE\Dependencies\Doctrine\ORM\Mapping\GeneratedValue;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Id;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Table;

/**
 * Doctrine Entity matching the wp_woocommerce_attribute_taxonomies table.
 */
#[Entity]
#[Table(name: 'attribute_taxonomies')]
class AttributeTaxonomy
{

    #[Id]
    #[GeneratedValue(strategy: 'IDENTITY')]
    #[Column('attribute_id', type: Types::BIGINT, options: ['unsigned' => true])]
    private ?int $id;

    #[Column('attribute_name', type: Types::STRING, length: 200, nullable: true)]
    private ?string $name;

    #[Column('attribute_label', type: Types::STRING, length: 200, nullable: true)]
    private ?string $label;

    #[Column('attribute_type', type: Types::STRING, length: 20, nullable: true)]
    private ?string $type;

    #[Column('attribute_orderby', type: Types::STRING, length: 20, nullable: true)]
    private ?string $orderby;

    #[Column('attribute_public', type: Types::BOOLEAN, nullable: true)]
    private ?bool $public;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return AttributeTaxonomy
     */
    public function setId(?int $id): AttributeTaxonomy
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return AttributeTaxonomy
     */
    public function setName(?string $name): AttributeTaxonomy
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLabel(): ?string
    {
        return $this->label;
    }

    /**
     * @param string|null $label
     * @return AttributeTaxonomy
     */
    public function setLabel(?string $label): AttributeTaxonomy
    {
        $this->label = $label;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @param string|null $type
     * @return AttributeTaxonomy
     */
    public function setType(?string $type): AttributeTaxonomy
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getOrderby(): ?string
    {
        return $this->orderby;
    }

    /**
     * @param string|null $orderby
     * @return AttributeTaxonomy
     */
    public function setOrderby(?string $orderby): AttributeTaxonomy
    {
        $this->orderby = $orderby;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getPublic(): ?bool
    {
        return $this->public;
    }

    /**
     * @param bool|null $public
     * @return AttributeTaxonomy
     */
    public function setPublic(?bool $public): AttributeTaxonomy
    {
        $this->public = $public;
        return $this;
    }

}