<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\Entity;

use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;
use WRCE\Dependencies\Symfony\Component\Serializer\Attribute\Groups;

/**
 * Entity mapping for the WordPress usermeta table.
 *
 * This entity uses {@see AbstractMeta} as a base class for generic meta table mapping.
 *
 * The {@see self::$id} property is overridden to use the `umeta_id` column name.
 */
#[
    ORM\Table('usermeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_usermeta'),
]
class UserMeta extends AbstractMeta
{

    /**
     * Override the default column name for.
     *
     * @var int|null
     */
    #[ORM\Column(name: 'umeta_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    #[Groups(['read_meta'])]
    protected ?int $id = null;

    #[
        ORM\ManyToOne(targetEntity: User::class, inversedBy: 'meta'),
        ORM\JoinColumn('user_id', referencedColumnName: 'ID')
    ]
    #[Groups(['read_meta_user'])]
    private User $user;

    public function getUser(): User
    {
        return $this->user;
    }

    public function setUser(User $user): UserMeta
    {
        $this->user = $user;
        return $this;
    }

    public static function getType(): string
    {
        return 'user';
    }

}
