<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\CliCommandAttributes\Attributes;

use Attribute;

/**
 * Attribute for WpCliCommand method arguments.
 *
 * Used to build the command synopsis and description.
 */
#[Attribute(Attribute::TARGET_PARAMETER)]
class CommandArgument
{

    /**
     * @psalm-param 'position'|'assoc'|'flag' $type
     */
    public function __construct(
        public readonly string $type,
        public readonly string $name,
        public readonly string $description,
        public readonly string $default = '',
        public readonly array $options = [],
        public readonly bool $optional = false,
        public readonly bool $repeating = false,
    )
    {

    }

}