<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace WRCE\Dependencies\Jawira\CaseConverter\Glue;

/**
 * Class DotNotation
 */
class DotNotation extends Gluer
{
    /** @internal */
    public const DELIMITER = '.';

    /**
     * Format detected words in _dot notation_
     *
     * @return string
     */
    public function glue(): string
    {
        return $this->glueUsingRules(self::DELIMITER, $this->lowerCase);
    }
}
