<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Tools\Event;

use WRCE\Dependencies\Doctrine\Common\EventArgs;
use WRCE\Dependencies\Doctrine\DBAL\Schema\Schema;
use WRCE\Dependencies\Doctrine\ORM\EntityManagerInterface;

/**
 * Event Args used for the Events::postGenerateSchema event.
 *
 * @link        www.doctrine-project.com
 */
class GenerateSchemaEventArgs extends EventArgs
{
    /** @var EntityManagerInterface */
    private $em;

    /** @var Schema */
    private $schema;

    public function __construct(EntityManagerInterface $em, Schema $schema)
    {
        $this->em     = $em;
        $this->schema = $schema;
    }

    /** @return EntityManagerInterface */
    public function getEntityManager()
    {
        return $this->em;
    }

    /** @return Schema */
    public function getSchema()
    {
        return $this->schema;
    }
}
