<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Repository\Exception;

use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;
use WRCE\Dependencies\Doctrine\ORM\Exception\RepositoryException;

final class InvalidFindByCall extends ORMException implements RepositoryException
{
    public static function fromInverseSideUsage(
        string $entityName,
        string $associationFieldName
    ): self {
        return new self(
            "You cannot search for the association field '" . $entityName . '#' . $associationFieldName . "', " .
            'because it is the inverse side of an association. Find methods only work on owning side associations.'
        );
    }
}
