<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM;

use function array_values;
use function is_int;
use function key;
use function ksort;

/**
 * Represents a native SQL query.
 *
 * @final
 */
class NativeQuery extends AbstractQuery
{
    /** @var string */
    private $sql;

    /**
     * Sets the SQL of the query.
     *
     * @param string $sql
     *
     * @return $this
     */
    public function setSQL($sql): self
    {
        $this->sql = $sql;

        return $this;
    }

    /**
     * Gets the SQL query.
     */
    public function getSQL(): string
    {
        return $this->sql;
    }

    /**
     * {@inheritDoc}
     */
    protected function _doExecute()
    {
        $parameters = [];
        $types      = [];

        foreach ($this->getParameters() as $parameter) {
            $name  = $parameter->getName();
            $value = $this->processParameterValue($parameter->getValue());
            $type  = $parameter->getValue() === $value
                ? $parameter->getType()
                : Query\ParameterTypeInferer::inferType($value);

            $parameters[$name] = $value;
            $types[$name]      = $type;
        }

        if ($parameters && is_int(key($parameters))) {
            ksort($parameters);
            ksort($types);

            $parameters = array_values($parameters);
            $types      = array_values($types);
        }

        return $this->_em->getConnection()->executeQuery(
            $this->sql,
            $parameters,
            $types,
            $this->_queryCacheProfile
        );
    }
}
