<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping\Exception;

use WRCE\Dependencies\Doctrine\DBAL\Platforms\AbstractPlatform;
use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;

use function get_debug_type;
use function sprintf;

final class CannotGenerateIds extends ORMException
{
    public static function withPlatform(AbstractPlatform $platform): self
    {
        return new self(sprintf(
            'Platform %s does not support generating identifiers',
            get_debug_type($platform)
        ));
    }
}
