<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping;

use Attribute;
use WRCE\Dependencies\Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;
use WRCE\Dependencies\Doctrine\ORM\EntityRepository;

/**
 * @Annotation
 * @NamedArgumentConstructor()
 * @Target("CLASS")
 * @template T of object
 */
#[Attribute(Attribute::TARGET_CLASS)]
final class Entity implements MappingAttribute
{
    /**
     * @var string|null
     * @psalm-var class-string<EntityRepository<T>>|null
     * @readonly
     */
    public $repositoryClass;

    /**
     * @var bool
     * @readonly
     */
    public $readOnly = false;

    /** @psalm-param class-string<EntityRepository<T>>|null $repositoryClass */
    public function __construct(?string $repositoryClass = null, bool $readOnly = false)
    {
        $this->repositoryClass = $repositoryClass;
        $this->readOnly        = $readOnly;
    }
}
