<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Exception;

use function sprintf;

final class MissingIdentifierField extends ORMException implements ManagerException
{
    public static function fromFieldAndClass(string $fieldName, string $className): self
    {
        return new self(sprintf(
            'The identifier %s is missing for a query of %s',
            $fieldName,
            $className
        ));
    }
}
