<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Exception;

use WRCE\Dependencies\Doctrine\ORM\EntityRepository;

final class InvalidEntityRepository extends ORMException implements ConfigurationException
{
    public static function fromClassName(string $className): self
    {
        return new self(
            "Invalid repository class '" . $className . "'. It must be a " . EntityRepository::class . '.'
        );
    }
}
