<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache\Region;

use WRCE\Dependencies\Doctrine\ORM\Cache\CacheKey;
use WRCE\Dependencies\Doctrine\ORM\Cache\TimestampCacheEntry;
use WRCE\Dependencies\Doctrine\ORM\Cache\TimestampRegion;

/**
 * Tracks the timestamps of the most recent updates to particular keys.
 */
class UpdateTimestampCache extends DefaultRegion implements TimestampRegion
{
    /**
     * {@inheritDoc}
     */
    public function update(CacheKey $key)
    {
        $this->put($key, new TimestampCacheEntry());
    }
}
