<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache\Persister\Entity;

use WRCE\Dependencies\Doctrine\ORM\Cache\EntityCacheKey;
use WRCE\Dependencies\Doctrine\ORM\Cache\EntityHydrator;
use WRCE\Dependencies\Doctrine\ORM\Cache\Persister\CachedPersister;
use WRCE\Dependencies\Doctrine\ORM\Persisters\Entity\EntityPersister;

/**
 * Interface for second level cache entity persisters.
 */
interface CachedEntityPersister extends CachedPersister, EntityPersister
{
    /** @return EntityHydrator */
    public function getEntityHydrator();

    /**
     * @param object $entity
     *
     * @return bool
     */
    public function storeEntityCache($entity, EntityCacheKey $key);
}
