<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache\Persister\Collection;

use WRCE\Dependencies\Doctrine\ORM\Cache\Exception\CannotUpdateReadOnlyCollection;
use WRCE\Dependencies\Doctrine\ORM\PersistentCollection;
use WRCE\Dependencies\Doctrine\ORM\Proxy\DefaultProxyClassNameResolver;

class ReadOnlyCachedCollectionPersister extends NonStrictReadWriteCachedCollectionPersister
{
     /**
      * {@inheritDoc}
      */
    public function update(PersistentCollection $collection)
    {
        if ($collection->isDirty() && $collection->getSnapshot()) {
            throw CannotUpdateReadOnlyCollection::fromEntityAndField(
                DefaultProxyClassNameResolver::getClass($collection->getOwner()),
                $this->association['fieldName']
            );
        }

        parent::update($collection);
    }
}
