<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache;

use function time;
use function uniqid;

class Lock
{
    /** @var string */
    public $value;

    /** @var int */
    public $time;

    public function __construct(string $value, ?int $time = null)
    {
        $this->value = $value;
        $this->time  = $time ?: time();
    }

    /** @return Lock */
    public static function createLockRead()
    {
        return new self(uniqid((string) time(), true));
    }
}
