<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache\Exception;

use function sprintf;

class NonCacheableEntityAssociation extends CacheException
{
    public static function fromEntityAndField(string $entityName, string $field): self
    {
        return new self(sprintf(
            'Entity association field "%s#%s" not configured as part of the second-level cache.',
            $entityName,
            $field
        ));
    }
}
