<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache;

use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;

use function sprintf;

/**
 * Exception for cache.
 */
class CacheException extends ORMException
{
    /**
     * @param string $sourceEntity
     * @param string $fieldName
     *
     * @return CacheException
     */
    public static function updateReadOnlyCollection($sourceEntity, $fieldName)
    {
        return new self(sprintf('Cannot update a readonly collection "%s#%s"', $sourceEntity, $fieldName));
    }

    /**
     * @deprecated This method is not used anymore.
     *
     * @param string $entityName
     *
     * @return CacheException
     */
    public static function updateReadOnlyEntity($entityName)
    {
        return new self(sprintf('Cannot update a readonly entity "%s"', $entityName));
    }

    /**
     * @param string $entityName
     *
     * @return CacheException
     */
    public static function nonCacheableEntity($entityName)
    {
        return new self(sprintf('Entity "%s" not configured as part of the second-level cache.', $entityName));
    }

    /**
     * @deprecated This method is not used anymore.
     *
     * @param string $entityName
     * @param string $field
     *
     * @return CacheException
     */
    public static function nonCacheableEntityAssociation($entityName, $field)
    {
        return new self(sprintf('Entity association field "%s#%s" not configured as part of the second-level cache.', $entityName, $field));
    }
}
