<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle;

use WRCE\Dependencies\Doctrine\ORM\EntityManagerInterface;
use WRCE\Dependencies\Doctrine\ORM\Query\Filter\SQLFilter;

/**
 * Configurator for an EntityManager
 */
class ManagerConfigurator
{
    /** @var string[] */
    private array $enabledFilters = [];

    /** @var array<string,array<string,string>> */
    private array $filtersParameters = [];

    /**
     * @param string[]                           $enabledFilters
     * @param array<string,array<string,string>> $filtersParameters
     */
    public function __construct(array $enabledFilters, array $filtersParameters)
    {
        $this->enabledFilters    = $enabledFilters;
        $this->filtersParameters = $filtersParameters;
    }

    /**
     * Create a connection by name.
     */
    public function configure(EntityManagerInterface $entityManager)
    {
        $this->enableFilters($entityManager);
    }

    /**
     * Enables filters for a given entity manager
     */
    private function enableFilters(EntityManagerInterface $entityManager): void
    {
        if (empty($this->enabledFilters)) {
            return;
        }

        $filterCollection = $entityManager->getFilters();
        foreach ($this->enabledFilters as $filter) {
            $this->setFilterParameters($filter, $filterCollection->enable($filter));
        }
    }

    /**
     * Sets default parameters for a given filter
     */
    private function setFilterParameters(string $name, SQLFilter $filter): void
    {
        if (empty($this->filtersParameters[$name])) {
            return;
        }

        $parameters = $this->filtersParameters[$name];
        foreach ($parameters as $paramName => $paramValue) {
            $filter->setParameter($paramName, $paramValue);
        }
    }
}
