<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Command\Proxy;

use WRCE\Dependencies\Doctrine\ORM\Tools\Console\Command\ConvertMappingCommand;
use WRCE\Dependencies\Doctrine\ORM\Tools\Export\Driver\AbstractExporter;
use WRCE\Dependencies\Doctrine\ORM\Tools\Export\Driver\XmlExporter;
use WRCE\Dependencies\Doctrine\ORM\Tools\Export\Driver\YamlExporter;
use WRCE\Dependencies\Symfony\Component\Console\Input\InputOption;

use function assert;

/**
 * Convert Doctrine ORM metadata mapping information between the various supported
 * formats.
 *
 * @deprecated use WRCE\Dependencies\Doctrine\ORM\Tools\Console\Command\ConvertMappingCommand instead
 *
 * @psalm-suppress UndefinedClass ORM < 3
 */
class ConvertMappingDoctrineCommand extends ConvertMappingCommand
{
    use OrmProxyCommand;

    /** @return void */
    protected function configure()
    {
        parent::configure();

        $this
            ->setName('doctrine:mapping:convert');

        if ($this->getDefinition()->hasOption('em')) {
            return;
        }

        $this->addOption('em', null, InputOption::VALUE_OPTIONAL, 'The entity manager to use for this command');
    }

    /**
     * @param string $toType
     * @param string $destPath
     *
     * @return AbstractExporter
     */
    protected function getExporter($toType, $destPath)
    {
        $exporter = parent::getExporter($toType, $destPath);
        assert($exporter instanceof AbstractExporter);
        if ($exporter instanceof XmlExporter) {
            $exporter->setExtension('.orm.xml');
        } elseif ($exporter instanceof YamlExporter) {
            $exporter->setExtension('.orm.yml');
        }

        return $exporter;
    }
}
