<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\Bundle\DoctrineBundle\Attribute;

use Attribute;

/**
 * Service tag to autoconfigure entity listeners.
 */
#[Attribute(Attribute::TARGET_CLASS | Attribute::IS_REPEATABLE)]
class AsEntityListener
{
    public function __construct(
        public ?string $event = null,
        public ?string $method = null,
        public ?bool $lazy = null,
        public ?string $entityManager = null,
        public ?string $entity = null,
        public ?int $priority = null,
    ) {
    }
}
