<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\DBAL\Schema\Exception;

use WRCE\Dependencies\Doctrine\DBAL\Schema\SchemaException;

use function sprintf;

/** @psalm-immutable */
final class ForeignKeyDoesNotExist extends SchemaException
{
    public static function new(string $foreignKeyName, string $table): self
    {
        return new self(
            sprintf('There exists no foreign key with the name "%s" on table "%s".', $foreignKeyName, $table),
            self::FOREIGNKEY_DOESNT_EXIST,
        );
    }
}
