<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 22-July-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Doctrine\DBAL\Event\Listeners;

use WRCE\Dependencies\Doctrine\Common\EventSubscriber;
use WRCE\Dependencies\Doctrine\DBAL\Event\ConnectionEventArgs;
use WRCE\Dependencies\Doctrine\DBAL\Events;
use WRCE\Dependencies\Doctrine\DBAL\Exception;

/**
 * Session init listener for executing a single SQL statement right after a connection is opened.
 *
 * @deprecated Implement a middleware instead.
 */
class SQLSessionInit implements EventSubscriber
{
    /** @var string */
    protected $sql;

    /** @param string $sql */
    public function __construct($sql)
    {
        $this->sql = $sql;
    }

    /**
     * @return void
     *
     * @throws Exception
     */
    public function postConnect(ConnectionEventArgs $args)
    {
        $args->getConnection()->executeStatement($this->sql);
    }

    /**
     * {@inheritDoc}
     */
    public function getSubscribedEvents()
    {
        return [Events::postConnect];
    }
}
