<?php

namespace RTMCustomMails\WooCommerce;

use RTMCustomMails\Email\RTMCustomEmail;
use WC_Email;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Action;

/**
 *
 */
class WoocommerceEmailSettingsTable
{

    #[Action('woocommerce_email_setting_column_status')]
    public function renderColumnStatus(WC_Email $email): void
    {
        echo '<td class="wc-email-settings-table-status">';

        if ($email->is_manual()) {
            echo '<span class="status-manual tips" data-tip="' . esc_attr__('Manually sent', 'woocommerce') . '">' . esc_html__('Manual', 'woocommerce') . '</span>';
        } elseif ($email->is_enabled()) {
            echo '<span class="status-enabled tips" data-tip="' . esc_attr__('Enabled', 'woocommerce') . '">' . esc_html__('Yes', 'woocommerce') . '</span>';
        } else {
            echo '<span class="status-disabled tips" data-tip="' . esc_attr__('Disabled', 'woocommerce') . '">-</span>';
        }

        echo '</td>';
    }
    #[Action('woocommerce_email_setting_column_name')]
    public function renderColumnName(WC_Email $email): void
    {
        $parts = explode("\\", get_class($email));
        $email_key = end($parts);

        echo '<td class="wc-email-settings-table-name">'
            . '<a href="' . esc_url(admin_url('admin.php?page=wc-settings&tab=email&section=' . strtolower($email_key))) . '">'
            . esc_html($email->get_title())
            . '</a>' . wc_help_tip($email->get_description())
            . '</td>';
    }
    #[Action('woocommerce_email_setting_column_email_type')]
    public function renderColumnEmailType(WC_Email $email): void
    {
        echo '<td class="wc-email-settings-table-email_type">'
            . esc_html($email->get_content_type())
            . '</td>';
    }
    #[Action('woocommerce_email_setting_column_recipient')]
    public function renderColumnRecipient(WC_Email $email): void
    {
        $recipient = esc_html(ucfirst($email instanceof RTMCustomEmail
            ? $email->getRecipientType()
            : ($email->is_customer_email()
                ? __('Customer', 'woocommerce')
                : $email->get_recipient()
            )));
        echo '<td class="wc-email-settings-table-recipient">'
            . $recipient
            . '</td>';
    }
    #[Action('woocommerce_email_setting_column_actions', 10, 2)]
    public function renderColumnActions(WC_Email $email, string $email_key): void
    {
        echo '<td class="wc-email-settings-table-actions">
                <a class="button float-end" href="' . esc_url(admin_url('admin.php?page=wc-settings&tab=email&section=' . strtolower($email_key))) . '">'
            . esc_html__('Manage', 'woocommerce')
            . '</a></td>';
    }


    /**
     * @param $list
     * @return mixed
     */
    #[Action('woocommerce_get_settings_pages')]
    public function replaceEmailSettingsTableRenderFunction($list): mixed
    {
        remove_all_filters('woocommerce_admin_field_email_notification');
        add_filter('woocommerce_admin_field_email_notification', [$this, 'renderEmailSettingsTable']);
        return $list;
    }

    public function renderEmailSettingsTable(): void
    {
        // Define emails that can be customised here.
        $mailer = WC()->mailer();
        $email_templates = $mailer->get_emails();

        ?>
        <tr valign="top">
            <td class="wc_emails_wrapper" colspan="2">
                <table class="wc_emails widefat" cellspacing="0">
                    <thead>
                    <tr>
                        <?php
                        $columns = apply_filters(
                            'woocommerce_email_setting_columns',
                            [
                                'status' => '',
                                'name' => __('Email', 'woocommerce'),
                                'email_type' => __('Content type', 'woocommerce'),
                                'recipient' => __('Recipient(s)', 'woocommerce'),
                                'actions' => '',
                            ]
                        );
                        foreach ($columns as $key => $column) {
                            echo '<th class="wc-email-settings-table-' . esc_attr($key) . '">' . esc_html($column) . '</th>';
                        }
                        ?>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    foreach ($email_templates as $emailKey => $email) {
                        echo '<tr>';

                        foreach ($columns as $key => $column) {
                            do_action('woocommerce_email_setting_column_' . $key, $email, $emailKey);
                        }

                        echo '</tr>';
                    }
                    ?>
                    </tbody>
                </table>
            </td>
        </tr>
        <?php
    }

}