<?php

namespace RTMCustomMails\WooCommerce;

use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Filter;

class OrderQuery
{

    #[Filter('woocommerce_order_data_store_cpt_get_orders_query', 10, 3)]
    public function addOrderNumberQueryVar($wpQueryVars, $queryVars, $orderDataStore)
    {
        if ($orderNumberLike = $queryVars['_order_number_like'] ?? false) {
            if (class_exists('WC_Seq_Order_Number')) {
                $wpQueryVars['meta_query'][] = [
                    'key' => '_order_number',
                    'value' => $orderNumberLike,
                    'compare' => 'LIKE'
                ];
            } else {
                $wpQueryVars['s'] = $orderNumberLike;
            }
        }

        return $wpQueryVars;
    }

}