<?php

namespace RTMCustomMails\Preview;

use RTMCustomMails\ContextBuilder\WPContextBuilder;
use RTMCustomMails\ObjectSupport\EmailObjectSupport;
use RTMCustomMails\ObjectSupport\EmailOrderSupport;
use RTMCustomMails\ObjectSupport\EmailUserSupport;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Action;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Filter;
use WRCE\Dependencies\WordpressModels\DependencyInjection\Initializer\Attributes\ForceInitialize;

#[ForceInitialize]
class EmailObjects
{
    private static ?EmailObjects $instance = null;
    /**
     * @var mixed|null
     */
    private array $supported;

    /**
     * @param EmailObjectSupport[] $supported
     */

    public static function instance(): EmailObjects
    {

        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    #[Filter('wrce_register_object_preview_support')]
    public function addDefaultObjectSupport(array $supported): array
    {
        return array_reduce(
            [EmailOrderSupport::instance(), EmailUserSupport::instance()],
            function ($carry, EmailObjectSupport $support) {
                $carry[$support->getObjectType()] = $support;
                return $carry;
            },
            $supported
        );
    }
    #[Action('init')]
    public function applyRegisteredObjectSupport(): void
    {
        $this->supported = apply_filters('wrce_register_object_preview_support', []);

        do_action('wrce_object_types_registered', $this->supported);
    }

    /**
     * @return array<string, EmailObjectSupport>
     */
    public function getSupported(): array
    {
        return $this->supported;
    }


}