<?php

namespace RTMCustomMails;

use RTMCustomMails\Email\RTMCustomEmail;
use RTMCustomMails\EmailOptions\OrderEmailHasProductEnabledCondition;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Action;
use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;

class OrderEmailOptions
{
    /**
     * @param RTMCustomEmail[] $emails
     * @return void
     */
    #[Action('wrce_register_options')]
    public function addDefaultOrderOptions(array $emails)
    {
        foreach ($emails as $email) {
            if ($email->getObjectType() !== 'order') {
                continue;
            }

            $email->addOption(OrderEmailHasProductEnabledCondition::class);
        }
    }


}