<?php

namespace RTMCustomMails;

use RTMCustomMails\Email\RTMCustomEmail;
use RTMCustomMails\EmailOptions\TriggerHooksOption;
use WC_Email;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Filter;

class EmailTriggerHooks
{
    /**
     * Add 'trigger_hooks' option to all available email types.
     *
     * @param \WC_Email[] $instances
     * @return void
     */
    #[Filter('wrce_register_options')]
    public function addTriggerHookOption(array $instances): void
    {
        foreach ($instances as $instance) {
            $instance = RTMCustomEmail::asCustomEmail($instance);
            $instance->addOption(TriggerHooksOption::class);
        }
    }
    #[Filter('wrce_email_trigger_hooks', 10, 2)]
    public function applyFilterHookOptionValue(array $hooks, WC_Email $email): array
    {
        return (array)$email->get_option('trigger_hooks', $hooks);
    }
}
