<?php

namespace RTMCustomMails\EmailSections;

use WRCE\Dependencies\Timber\Timber;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Filter;

/**
 *
 */
class EmailSections
{
    public function __construct(protected SectionValidation $sectionValidation)
    {
        Timber::$twig_cache = WP_DEBUG;
    }

    public static function getSectionPresets()
    {
        return apply_filters('wrce_email_section_presets', get_option('wrce_email_section_presets', []));
    }

    /**
     * @param string $location
     * @return string
     */
    #[Filter('timber/cache/location')]
    public function setTimberCacheLocation(string $location): string
    {
        return WP_DEBUG ? (WRCE_ROOT_PATH . 'cache/') : $location;
    }

    /**
     * @param string[] $locations
     * @return string[]
     */
    #[Filter('timber/locations')]
    public function addTimberTemplateLocations(array $locations = []): array
    {
        $locations[] = WRCE_ROOT_PATH . 'templates/emails/';

        return $locations;
    }

}