<?php

namespace RTMCustomMails\EmailSections\Defaults;

class CustomerResetPasswordDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_reset_password';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections(): array
    {
        return [
            [
                'id' => 'woocommerce_email_header',
                'enable' => true,
                'title' => 'Header',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 0,
            ],
            [
                'id' => 'greeting',
                'enable' => true,
                'title' => 'Greeting',
                'showTitle' => false,
                'text' => esc_html__('Hi {{ user_login }},', 'woocommerce'),
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'main_text',
                'enable' => true,
                'title' => 'Main Text',
                'showTitle' => false,
                'text' => <<<TWIG
Someone has requested a new password for the following account on {{ site_title }}:
Username: {{ user_login }}
If you didn't make this request, just ignore this email. If you'd like to proceed:
{{ link(woocommerce_lost_password_url, 'Click here to reset your password', ['link']) }}
TWIG,
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'woocommerce_email_additional_content',
                'enable' => true,
                'title' => 'Additional Content',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 4,
            ],
            [
                'id' => 'woocommerce_email_footer',
                'enable' => true,
                'title' => 'Footer',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 5,
            ]
        ];
    }
}
