<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\Model\CustomMail;
use WP_User;

class UserContextBuilder extends ObjectTypeContextBuilder
{
    public function __construct()
    {
        parent::__construct('user');
    }

    /**
     * Defines the data available to email when handling user-related contexts.
     */
    protected function defineWhitelist(): array
    {
        return [
            ['variable' => 'password_reset_link', 'description' => 'Link to reset password'],
            ['variable' => 'user_id', 'description' => 'User\'s ID'],
            ['variable' => 'user_login', 'description' => 'User\'s login name'],
            ['variable' => 'user_email', 'description' => 'User\'s email address'],
            ['variable' => 'user_first_name', 'description' => 'User\'s first name'],
            ['variable' => 'user_last_name', 'description' => 'User\'s last name'],
            ['variable' => 'user_display_name', 'description' => 'User\'s display name'],
            ['variable' => 'user_nicename', 'description' => 'User\'s nice name'],
            ['variable' => 'user_url', 'description' => 'User\'s website URL'],
            ['variable' => 'user_registered', 'description' => 'User\'s registration date'],
            ['variable' => 'user_description', 'description' => 'User\'s description'],
        ];
    }


    /**
     * Prepares the data context specifically for user-related emails.
     */
    protected function buildContext(CustomMail $mail, $mailObject, array $context = []): array
    {
        /** @var WP_User $user */
        $user = $mailObject instanceof WP_User ? $mailObject : new WP_User();


        $context['password_reset_link'] = esc_url(wp_lostpassword_url());
        $context['user_id'] = $user->ID;
        $context['user_login'] = $user->user_login;
        $context['user_email'] = $user->user_email;
        $context['user_first_name'] = $user->first_name;
        $context['user_last_name'] = $user->last_name;
        $context['user_display_name'] = $user->display_name;
        $context['user_nicename'] = $user->user_nicename;
        $context['user_url'] = $user->user_url;
        $context['user_registered'] = $user->user_registered;
        $context['user_description'] = $user->description;

        return apply_filters('wrce_inject_context/object_type=user', $context, $mail, $mailObject);
    }
}
