<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\Model\CustomMail;
use WC_Order;
use WP_User;

class CustomerContextBuilder extends RecipientTypeContextBuilder
{
    public function __construct()
    {
        parent::__construct('customer');
    }

    /**
     * Define the whitelist specific to customer context.
     */
    protected function defineWhitelist(): array
    {
        return [
            ['variable' => 'customer_name', 'description' => 'Customer\'s name'],
            ['variable' => 'customer_since', 'description' => 'Customer since date'],
            ['variable' => 'customer_order_count', 'description' => 'Number of customer orders'],
            ['variable' => 'customer_note', 'description' => 'Customer notes'],
        ];
    }


    protected function buildContext(CustomMail $mail, $mailObject, array $context = []): array
    {
            $user = $context['user'];
            $context['customer_since'] = $user->user_registered;
            $context['customer_order_count'] = wc_get_customer_order_count($user->ID);
            $context['customer_note'] = get_user_meta($user->ID, 'customer_note', true);
            $context['customer_name'] = (get_bloginfo('name'));

        return apply_filters("wcre_prepare_context_{$this->getSubject()}", $context, $mail, $mailObject);
    }
}
