<?php

namespace RTMCustomMails\ContextBuilder;

use RTMMailComposer\Model\CustomMail;
use WP_User;

class AdminContextBuilder extends RecipientTypeContextBuilder
{
    public function __construct()
    {
        parent::__construct('admin');
    }

    protected function defineWhitelist(): array
    {
        return [
            ['variable' => 'admin_name', 'description' => 'Administrator\'s name'],
            ['variable' => 'admin_email', 'description' => 'Administrator\'s email'],
        ];
    }


    protected function buildContext(CustomMail $mail, $mailObject, array $context = []): array
    {
        $admin_user = get_user_by('email', get_option('admin_email'));
        if ($admin_user instanceof WP_User) {
            $context['admin_name'] = trim($admin_user->first_name . ' ' . $admin_user->last_name) ?: $admin_user->display_name;
            $context['admin_email'] = $admin_user->user_email;
        } else {
            $context['admin_name'] = 'Admin';
            $context['admin_email'] = get_option('admin_email');
        }
        return apply_filters("wcre_prepare_context_{$this->getSubject()}", $context, $mail, $mailObject);
    }
}
