<?php
namespace RTMCustomMails\ConditionSchema;

use RTMCustomMails\Email\RTMCustomEmail;
use RTMMailComposer\AbstractConditionSchemaBuilder;
use RTMMailComposer\ConditionProcessor\ConditionFunctionInterface;
use RTMMailComposer\Model\CustomMail;

class ConditionSchemaBuilder extends AbstractConditionSchemaBuilder
{
    /**
     * @param RTMCustomEmail $email
     * @return ConditionFunctionInterface[]
     */
    protected function getFunctionInstances(CustomMail $email): array
    {
        $functions = apply_filters('wrce_email_condition_functions', []);
        $functions = apply_filters("wrce_email_condition_functions/object_type={$email->getObjectType()}", $functions);
        $functions = apply_filters("wrce_email_condition_functions/recipient_type={$email->getRecipientType()}", $functions);

        return array_reduce($functions, function (array $carry, string $f) {
            if (class_implements($f, ConditionFunctionInterface::class)) {
                $conditionInstance = new $f();
                if ($this->validateConditionInstance($conditionInstance)) {
                    $carry[] = $conditionInstance;
                }
            }
            return $carry;
        }, []);
    }

    /**
     * Validate the condition instance to ensure all enums are not empty.
     *
     * @param ConditionFunctionInterface $conditionInstance
     * @return bool
     */
    private function validateConditionInstance(ConditionFunctionInterface $conditionInstance): bool
    {
        $parameters = $conditionInstance->getParameters();
        foreach ($parameters as $parameter) {
            if (isset($parameter['enum']) && empty($parameter['enum'])) {
                return false;
            }
        }
        return true;
    }
}
