<?php

use RTMCustomMails\ContextBuilder\WPContextBuilder;
use RTMCustomMails\Email\EmailClassesService;
use RTMCustomMails\Email\RTMCustomEmail_New_Order;
use RTMCustomMails\EmailSections\ActionSectionRender;
use RTMCustomMails\EmailSections\Defaults\DefaultLoader;
use RTMCustomMails\EmailSections\EmailSections;
use RTMCustomMails\EmailSections\SectionValidation;
use RTMCustomMails\EmailSections\TwigFunctions;
use RTMCustomMails\EmailTriggerHooks;
use RTMCustomMails\Migrations;
use RTMCustomMails\OrderEmailOptions;
use RTMCustomMails\PDFInvoices\WoocommercePDFInvoices;
use RTMCustomMails\Preview\DisallowPreviews;
use RTMCustomMails\Preview\EmailObjects;
use RTMCustomMails\Preview\PreviewEmails;
use RTMCustomMails\Renderer\TimberEmailRenderer;
use RTMCustomMails\Schedule\ScheduledEmails;
use RTMCustomMails\WooCommerce\OrderQuery;
use RTMCustomMails\WooCommerce\WooCommerceEmails;
use RTMCustomMails\WooCommerce\WoocommerceEmailSettingsTable;
use RTMCustomMails\WooCommerce\WooCommerceSchemaConverter;
use RTMCustomMails\WooCommerce\WooCommerceTemplate;
use RTMMailComposer\ContextBuilder\ContextBuilderRegistry;
use RTMMailComposer\Renderer\TwigEmailRenderer;
use WRCE\Dependencies\Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use function WRCE\Dependencies\Symfony\Component\DependencyInjection\Loader\Configurator\service;

return static function (ContainerConfigurator $configurator) {
    $services = $configurator->services();

    $services->load('RTMCustomMails\\Rest\\', __DIR__ . '/../src/Rest/')
        ->autowire()
        ->autoconfigure();

    $services->set(EmailClassesService::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(Migrations::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(WPContextBuilder::class)
        ->public()
        ->autoconfigure()
        ->args([service(ContextBuilderRegistry::class)]);

    $services->set(ContextBuilderRegistry::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(TimberEmailRenderer::class)
        ->public()
        ->autoconfigure()
        ->constructor('instance')
        ->args([service(WPContextBuilder::class)]);

    $services->set(TwigEmailRenderer::class)
        ->public()
        ->autoconfigure()
        ->args([service(ContextBuilderRegistry::class)]);

    $services->set(SectionValidation::class)
        ->public()
        ->args([service(WPContextBuilder::class)])
        ->autoconfigure();

    $services->set(EmailSections::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(PreviewEmails::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(WoocommercePDFInvoices::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(OrderQuery::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(WooCommerceEmails::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(WooCommerceTemplate::class)
        ->public()
        ->autoconfigure()
        ->autowire();
    $services->set(EmailTriggerHooks::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(EmailObjects::class)
        ->constructor('instance')
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(OrderEmailOptions::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(DefaultLoader::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(TwigFunctions::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(DisallowPreviews::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(WoocommerceEmailSettingsTable::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(ActionSectionRender::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(ScheduledEmails::class)
        ->public()
        ->autoconfigure()
        ->autowire();

    $services->set(WooCommerceSchemaConverter::class)
        ->public()
        ->autowire()
        ->autoconfigure();

};
