"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[692],{

/***/ 90692:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailSettingsRoute)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(28510);
// EXTERNAL MODULE: ./assets/src/js/react/lib/rjsf/SchemaForm/index.tsx + 32 modules
var SchemaForm = __webpack_require__(5725);
;// CONCATENATED MODULE: ./assets/src/js/schema/settings.uiSchema.json
const settings_uiSchema_namespaceObject = JSON.parse('{"ui:submitButtonOptions":{"props":{"className":"self-end"}},"trigger_hooks":{"ui:widget":"multiselect"}}');
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./assets/src/js/react/lib/actions/email.ts
var actions_email = __webpack_require__(99784);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/createLucideIcon.js + 3 modules
var createLucideIcon = __webpack_require__(36861);
;// CONCATENATED MODULE: ./node_modules/lucide-react/dist/esm/icons/upload.js
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const Upload = (0,createLucideIcon/* default */.Z)("Upload", [
  ["path", { d: "M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4", key: "ih7n3h" }],
  ["polyline", { points: "17 8 12 3 7 8", key: "t8dd8p" }],
  ["line", { x1: "12", x2: "12", y1: "3", y2: "15", key: "widbto" }]
]);


//# sourceMappingURL=upload.js.map

;// CONCATENATED MODULE: ./node_modules/lucide-react/dist/esm/icons/download.js
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const Download = (0,createLucideIcon/* default */.Z)("Download", [
  ["path", { d: "M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4", key: "ih7n3h" }],
  ["polyline", { points: "7 10 12 15 17 10", key: "2ggqvy" }],
  ["line", { x1: "12", x2: "12", y1: "15", y2: "3", key: "1vk2je" }]
]);


//# sourceMappingURL=download.js.map

;// CONCATENATED MODULE: ./assets/src/js/react/components/DeleteEmailModal.tsx


function DeleteEmailModal(param) {
    var show = param.show, onClose = param.onClose, onConfirm = param.onConfirm, loading = param.loading;
    if (!show) {
        return null;
    }
    return /*#__PURE__*/ external_React_default().createElement("div", {
        className: "fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50"
    }, /*#__PURE__*/ external_React_default().createElement("div", {
        className: "bg-white p-6 rounded-lg"
    }, /*#__PURE__*/ external_React_default().createElement("h2", {
        className: "text-lg font-semibold mb-4"
    }, "Are you sure you want to delete this email?"), /*#__PURE__*/ external_React_default().createElement("div", {
        className: "flex justify-center"
    }, /*#__PURE__*/ external_React_default().createElement(react.Button, {
        onClick: onClose,
        className: "mr-2 border border-gray-200 bg-gray-300",
        disabled: loading
    }, "Cancel"), /*#__PURE__*/ external_React_default().createElement(react.Button, {
        onClick: onConfirm,
        className: "border border-gray-200 bg-red-500 text-white",
        disabled: loading
    }, loading ? /*#__PURE__*/ external_React_default().createElement(react.Spinner, {
        className: "w-4 h-4"
    }) : 'Delete'))));
}
/* harmony default export */ const components_DeleteEmailModal = (DeleteEmailModal);

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSettings.tsx
function _array_like_to_array(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for(var i = 0, arr2 = new Array(len); i < len; i++)arr2[i] = arr[i];
    return arr2;
}
function _array_with_holes(arr) {
    if (Array.isArray(arr)) return arr;
}
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _instanceof(left, right) {
    if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) {
        return !!right[Symbol.hasInstance](left);
    } else {
        return left instanceof right;
    }
}
function _iterable_to_array_limit(arr, i) {
    var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
    if (_i == null) return;
    var _arr = [];
    var _n = true;
    var _d = false;
    var _s, _e;
    try {
        for(_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true){
            _arr.push(_s.value);
            if (i && _arr.length === i) break;
        }
    } catch (err) {
        _d = true;
        _e = err;
    } finally{
        try {
            if (!_n && _i["return"] != null) _i["return"]();
        } finally{
            if (_d) throw _e;
        }
    }
    return _arr;
}
function _non_iterable_rest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _object_spread(target) {
    for(var i = 1; i < arguments.length; i++){
        var source = arguments[i] != null ? arguments[i] : {};
        var ownKeys = Object.keys(source);
        if (typeof Object.getOwnPropertySymbols === "function") {
            ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym) {
                return Object.getOwnPropertyDescriptor(source, sym).enumerable;
            }));
        }
        ownKeys.forEach(function(key) {
            _define_property(target, key, source[key]);
        });
    }
    return target;
}
function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly) {
            symbols = symbols.filter(function(sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        }
        keys.push.apply(keys, symbols);
    }
    return keys;
}
function _object_spread_props(target, source) {
    source = source != null ? source : {};
    if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
        ownKeys(Object(source)).forEach(function(key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
    }
    return target;
}
function _sliced_to_array(arr, i) {
    return _array_with_holes(arr) || _iterable_to_array_limit(arr, i) || _unsupported_iterable_to_array(arr, i) || _non_iterable_rest();
}
function _type_of(obj) {
    "@swc/helpers - typeof";
    return obj && typeof Symbol !== "undefined" && obj.constructor === Symbol ? "symbol" : typeof obj;
}
function _unsupported_iterable_to_array(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _array_like_to_array(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(n);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _array_like_to_array(o, minLen);
}









var toast = window.toast;
var isEmptyValue = function(value) {
    return !value || Array.isArray(value) && value.length === 0 || (typeof value === "undefined" ? "undefined" : _type_of(value)) === 'object' && Object.keys(value).length === 0 || value === '';
};
function EmailSettings(param) {
    var email = param.email, onEmailUpdated = param.onEmailUpdated, _param_disabled = param.disabled, disabled = _param_disabled === void 0 ? false : _param_disabled;
    var mutate = (0,datafetching_email/* useEmailMutate */.FX)();
    var _React_useState = _sliced_to_array(external_React_default().useState(false), 2), submitting = _React_useState[0], setSubmitting = _React_useState[1];
    var _useEmailSettingsSchema = (0,datafetching_email/* useEmailSettingsSchema */.J$)(email), schema = _useEmailSettingsSchema.data, isLoadingSchema /*, error: schemaError*/  = _useEmailSettingsSchema.isLoading;
    var _React_useState1 = _sliced_to_array(external_React_default().useState(false), 2), exporting = _React_useState1[0], setExporting = _React_useState1[1];
    var _React_useState2 = _sliced_to_array(external_React_default().useState(false), 2), importing = _React_useState2[0], setImporting = _React_useState2[1];
    var importRef = external_React_default().useRef(null);
    var _email_settings;
    var _React_useState3 = _sliced_to_array(external_React_default().useState((_email_settings = email.settings) !== null && _email_settings !== void 0 ? _email_settings : {}), 2), settings = _React_useState3[0], setSettings = _React_useState3[1];
    var _React_useState4 = _sliced_to_array(external_React_default().useState(false), 2), showModal = _React_useState4[0], setShowModal = _React_useState4[1];
    var _React_useState5 = _sliced_to_array(external_React_default().useState(false), 2), deleting = _React_useState5[0], setDeleting = _React_useState5[1];
    var navigate = (0,dist/* useNavigate */.s0)();
    var saveSettings = function(data) {
        setSubmitting(true);
        (0,actions_email/* saveEmail */.it)(_object_spread_props(_object_spread({}, email), {
            settings: data
        })).catch(function(error) {
            toast.error('Error saving email sections: ' + error.message);
        }).then(function(email) {
            toast.success('Email sections saved', {
                duration: 3000
            });
            onEmailUpdated(email);
        }).finally(function() {
            return setSubmitting(false);
        });
    };
    var exportSettings = function() {
        setExporting(true);
        (0,actions_email/* exportEmail */.Cu)(email).then(function(response) {
            var a = document.createElement("a");
            var file = new Blob([
                JSON.stringify(response)
            ], {
                type: 'text/plain'
            });
            a.href = URL.createObjectURL(file);
            a.download = 'export-' + email.id + '.json';
            a.click();
        }).catch(function(err) {
            return toast.error("Error exporting email settings: ".concat(err.message));
        }).finally(function() {
            return setExporting(false);
        });
    };
    var importSettings = function() {
        var _importRef_current;
        setImporting(true);
        var response = confirm("Importing email settings will overwrite your current settings. Make sure you have a backup of your current settings. Do you want to continue?");
        if (!response) {
            setImporting(false);
            return;
        }
        (_importRef_current = importRef.current) === null || _importRef_current === void 0 ? void 0 : _importRef_current.click();
    };
    var onFileInput = (0,external_React_.useCallback)(function(e) {
        var _e_target_files;
        var file = (_e_target_files = e.target.files) === null || _e_target_files === void 0 ? void 0 : _e_target_files[0];
        if (file) {
            var reader = new FileReader();
            reader.onload = function(evt) {
                var _evt_target;
                var content = (_evt_target = evt.target) === null || _evt_target === void 0 ? void 0 : _evt_target.result;
                try {
                    var data = JSON.parse(content);
                    (0,actions_email/* importEmail */.KH)(email, data).then(function(email) {
                        return mutate(email);
                    }).catch(function(error) {
                        return toast.error('Error importing email settings: ' + error.message);
                    }).finally(function() {
                        return setImporting(false);
                    });
                } catch (e) {
                    toast.error('Error reading file: ' + (_instanceof(e, Error) ? e.message : 'Unknown error'));
                }
            };
            reader.readAsText(file);
        }
    }, [
        email
    ]);
    var suppressEmptyOptionalObjectError = (0,external_React_.useCallback)(function(errors) {
        var shouldSuppressError = function shouldSuppressError(formData, error) {
            if (error.name === 'required' && error.property) {
                var parentFieldId = error.property.replace("['".concat(error.params.missingProperty, "']"), '').replace("['", '').replace("']", '');
                var parentFieldValue = formData[parentFieldId];
                return Boolean(parentFieldId) && JSON.stringify(parentFieldValue) === '{}';
            }
            if (error.property && isEmptyValue(settings[error.property])) {
                return true;
            }
            return false;
        };
        return errors.filter(function(error) {
            return !shouldSuppressError(settings, error);
        });
    }, [
        settings
    ]);
    var handleDelete = function() {
        setShowModal(true);
    };
    var confirmDelete = function() {
        setSubmitting(true);
        setDeleting(true);
        (0,actions_email/* deleteEmail */.nd)(email.id).then(function() {
            toast.success('Email deleted successfully', {
                duration: 3000
            });
            onEmailUpdated(email);
            navigate('/');
        }).catch(function(error) {
            toast.error('Error deleting email: ' + error.message);
        }).finally(function() {
            setSubmitting(false);
            setDeleting(false);
            setShowModal(false);
        });
    };
    var handleDynamicSettings = function() {
        navigate("/".concat(email.id, "/dynamic-settings"));
    };
    return /*#__PURE__*/ external_React_default().createElement((external_React_default()).Fragment, null, isLoadingSchema && /*#__PURE__*/ external_React_default().createElement("div", {
        className: 'flex justify-center mb-2'
    }, /*#__PURE__*/ external_React_default().createElement(react.Spinner, null)), /*#__PURE__*/ external_React_default().createElement(SchemaForm/* default */.Z, {
        disabled: disabled || isLoadingSchema || submitting,
        schema: schema !== null && schema !== void 0 ? schema : {},
        uiSchema: settings_uiSchema_namespaceObject,
        data: settings,
        transformErrors: suppressEmptyOptionalObjectError,
        onSubmit: saveSettings,
        onChange: function(param) {
            var formData = param.formData;
            setSettings(formData);
        },
        submitLabel: submitting ? 'Saving...' : 'Save'
    }), /*#__PURE__*/ external_React_default().createElement(react.ButtonGroup, {
        size: 'sm',
        color: 'white',
        fullWidth: true,
        className: 'mt-2'
    }, /*#__PURE__*/ external_React_default().createElement(react.Button, {
        onClick: importSettings,
        className: 'border border-gray-200 inline-flex justify-center',
        disabled: importing
    }, /*#__PURE__*/ external_React_default().createElement(Upload, {
        className: 'pr-1',
        size: 16
    }), importing ? /*#__PURE__*/ external_React_default().createElement(react.Spinner, {
        className: 'w-4 h-4 pr-1'
    }) : 'Import'), /*#__PURE__*/ external_React_default().createElement(react.Button, {
        onClick: exportSettings,
        className: 'border border-gray-200 inline-flex justify-center',
        disabled: exporting
    }, /*#__PURE__*/ external_React_default().createElement(Download, {
        className: 'pr-1',
        size: 16
    }), exporting ? /*#__PURE__*/ external_React_default().createElement(react.Spinner, {
        className: 'w-4 h-4 pr-1'
    }) : 'Export')), email.isDynamic && /*#__PURE__*/ external_React_default().createElement(react.ButtonGroup, {
        size: 'sm',
        color: 'white',
        fullWidth: true,
        className: 'mt-2'
    }, /*#__PURE__*/ external_React_default().createElement(react.Button, {
        onClick: handleDelete,
        className: 'border border-gray-200 inline-flex justify-center bg-red-500 text-white',
        disabled: submitting
    }, "Delete"), /*#__PURE__*/ external_React_default().createElement(react.Button, {
        onClick: handleDynamicSettings,
        className: 'border border-gray-200 inline-flex justify-center bg-blue-500 text-white',
        disabled: submitting
    }, "Dynamic settings")), /*#__PURE__*/ external_React_default().createElement("input", {
        type: "file",
        accept: "application/json",
        className: "hidden",
        onInput: onFileInput,
        ref: importRef
    }), /*#__PURE__*/ external_React_default().createElement(components_DeleteEmailModal, {
        show: showModal,
        onClose: function() {
            return setShowModal(false);
        },
        onConfirm: confirmDelete,
        loading: deleting
    }));
}
/* harmony default export */ const components_EmailSettings = (EmailSettings);

;// CONCATENATED MODULE: ./assets/src/js/react/routes/EmailSettingsRoute.tsx




/* harmony default export */ function EmailSettingsRoute() {
    var revalidateAll = (0,datafetching_email/* useEmailsMutate */.zv)();
    var ctx = (0,dist/* useOutletContext */.bx)();
    var onUpdated = function() {
        revalidateAll();
    };
    return /*#__PURE__*/ external_React_default().createElement(components_EmailSettings, {
        key: ctx.email.id,
        email: ctx.email,
        onEmailUpdated: onUpdated
    });
}


/***/ })

}]);