<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Symfony\Component\DependencyInjection\Loader\Configurator;

use Symfony\Component\Validator\DataCollector\ValidatorDataCollector;
use Symfony\Component\Validator\Validator\TraceableValidator;

return static function (ContainerConfigurator $container) {
    $container->services()
        ->set('debug.validator', TraceableValidator::class)
            ->decorate('validator', null, 255)
            ->args([
                service('debug.validator.inner'),
            ])
            ->tag('kernel.reset', [
                'method' => 'reset',
            ])

        ->set('data_collector.validator', ValidatorDataCollector::class)
            ->args([
                service('debug.validator'),
            ])
            ->tag('data_collector', [
                'template' => '@WebProfiler/Collector/validator.html.twig',
                'id' => 'validator',
                'priority' => 320,
            ])
    ;
};
