<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Symfony\Bridge\Doctrine\SchemaListener;

use WRCE\Dependencies\Doctrine\ORM\Tools\Event\GenerateSchemaEventArgs;
use WRCE\Dependencies\Symfony\Component\HttpFoundation\Session\Storage\Handler\PdoSessionHandler;

final class PdoSessionHandlerSchemaListener extends AbstractSchemaListener
{
    private PdoSessionHandler $sessionHandler;

    public function __construct(\SessionHandlerInterface $sessionHandler)
    {
        if ($sessionHandler instanceof PdoSessionHandler) {
            $this->sessionHandler = $sessionHandler;
        }
    }

    public function postGenerateSchema(GenerateSchemaEventArgs $event): void
    {
        if (!isset($this->sessionHandler)) {
            return;
        }

        $connection = $event->getEntityManager()->getConnection();

        $this->sessionHandler->configureSchema($event->getSchema(), $this->getIsSameDatabaseChecker($connection));
    }
}
