<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'tax_rate_locations')]
class TaxRateLocation
{
    #[ORM\Id]
    #[ORM\Column(name: 'location_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[ORM\Column(name: 'location_code', type: Types::STRING, length: 200, options: ['notnull' => true])]
    private string $code;

    #[ORM\ManyToOne(targetEntity: TaxRate::class)]
    #[ORM\JoinColumn(name: 'tax_rate_id', referencedColumnName: 'tax_rate_id', nullable: false)]
    private TaxRate $taxRate;

    #[ORM\Column(name: 'location_type', type: Types::STRING, length: 40, options: ['notnull' => true])]
    private string $type;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return TaxRateLocation
     */
    public function setId(?int $id): TaxRateLocation
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return TaxRateLocation
     */
    public function setCode(string $code): TaxRateLocation
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return TaxRate
     */
    public function getTaxRate(): TaxRate
    {
        return $this->taxRate;
    }

    /**
     * @param TaxRate $taxRate
     * @return TaxRateLocation
     */
    public function setTaxRate(TaxRate $taxRate): TaxRateLocation
    {
        $this->taxRate = $taxRate;
        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return TaxRateLocation
     */
    public function setType(string $type): TaxRateLocation
    {
        $this->type = $type;
        return $this;
    }

}