<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\Common\Collections\Collection;
use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'tax_rates')]
class TaxRate
{
    #[ORM\Id]
    #[ORM\Column(name: 'tax_rate_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[ORM\Column(name: 'tax_rate_country', type: Types::STRING, length: 2, options: ['default' => '', 'notnull' => true])]
    private string $country = '';

    #[ORM\Column(name: 'tax_rate_state', type: Types::STRING, length: 200, options: ['default' => '', 'notnull' => true])]
    private string $state = '';

    #[ORM\Column(name: 'tax_rate', type: Types::STRING, length: 8, options: ['default' => '', 'notnull' => true])]
    private string $rate = '';

    #[ORM\Column(name: 'tax_rate_name', type: Types::STRING, length: 200, options: ['default' => '', 'notnull' => true])]
    private string $name = '';

    #[ORM\Column(name: 'tax_rate_priority', type: Types::BIGINT, options: ['unsigned' => true, 'notnull' => true])]
    private int $priority;

    #[ORM\Column(name: 'tax_rate_compound', type: Types::INTEGER, options: ['default' => 0, 'notnull' => true])]
    private int $compound = 0;

    #[ORM\Column(name: 'tax_rate_shipping', type: Types::INTEGER, options: ['default' => 1, 'notnull' => true])]
    private int $shipping = 1;

    #[ORM\Column(name: 'tax_rate_order', type: Types::BIGINT, options: ['unsigned' => true, 'notnull' => true])]
    private int $order;

    #[ORM\Column(name: 'tax_rate_class', type: Types::STRING, length: 200, options: ['default' => '', 'notnull' => true])]
    private string $class = '';

    #[ORM\OneToMany(mappedBy: 'taxRate', targetEntity: TaxRateLocation::class)]
    private Collection $locations;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return TaxRate
     */
    public function setId(?int $id): TaxRate
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountry(): string
    {
        return $this->country;
    }

    /**
     * @param string $country
     * @return TaxRate
     */
    public function setCountry(string $country): TaxRate
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @param string $state
     * @return TaxRate
     */
    public function setState(string $state): TaxRate
    {
        $this->state = $state;
        return $this;
    }

    /**
     * @return string
     */
    public function getRate(): string
    {
        return $this->rate;
    }

    /**
     * @param string $rate
     * @return TaxRate
     */
    public function setRate(string $rate): TaxRate
    {
        $this->rate = $rate;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return TaxRate
     */
    public function setName(string $name): TaxRate
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getPriority(): int
    {
        return $this->priority;
    }

    /**
     * @param int $priority
     * @return TaxRate
     */
    public function setPriority(int $priority): TaxRate
    {
        $this->priority = $priority;
        return $this;
    }

    /**
     * @return int
     */
    public function getCompound(): int
    {
        return $this->compound;
    }

    /**
     * @param int $compound
     * @return TaxRate
     */
    public function setCompound(int $compound): TaxRate
    {
        $this->compound = $compound;
        return $this;
    }

    /**
     * @return int
     */
    public function getShipping(): int
    {
        return $this->shipping;
    }

    /**
     * @param int $shipping
     * @return TaxRate
     */
    public function setShipping(int $shipping): TaxRate
    {
        $this->shipping = $shipping;
        return $this;
    }

    /**
     * @return int
     */
    public function getOrder(): int
    {
        return $this->order;
    }

    /**
     * @param int $order
     * @return TaxRate
     */
    public function setOrder(int $order): TaxRate
    {
        $this->order = $order;
        return $this;
    }

    /**
     * @return string
     */
    public function getClass(): string
    {
        return $this->class;
    }

    /**
     * @param string $class
     * @return TaxRate
     */
    public function setClass(string $class): TaxRate
    {
        $this->class = $class;
        return $this;
    }

    /**
     * @return Collection
     */
    public function getLocations(): Collection
    {
        return $this->locations;
    }

    /**
     * @param Collection $locations
     * @return TaxRate
     */
    public function setLocations(Collection $locations): TaxRate
    {
        $this->locations = $locations;
        return $this;
    }

}