<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\ORM\Mapping\Entity;
use WRCE\Dependencies\Doctrine\ORM\Mapping\JoinColumn;
use WRCE\Dependencies\Doctrine\ORM\Mapping\ManyToOne;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Table;
use WRCE\Dependencies\WordpressModels\ORM\Entity\AbstractMeta;


/**
 * Doctrine Entity matching the wp_woocommerce_order_itemmeta table.
 */
#[Entity]
#[Table(name: 'order_itemmeta')]
class OrderItemMeta extends AbstractMeta
{

    #[ManyToOne(targetEntity: OrderItem::class, inversedBy: 'meta')]
    #[JoinColumn(name: 'order_item_id', referencedColumnName: 'order_item_id')]
    private OrderItem $orderItem;

    /**
     * @return OrderItem
     */
    public function getOrderItem(): OrderItem
    {
        return $this->orderItem;
    }

    /**
     * @param OrderItem $orderItem
     * @return OrderItemMeta
     */
    public function setOrderItem(OrderItem $orderItem): OrderItemMeta
    {
        $this->orderItem = $orderItem;
        return $this;
    }

    public static function getType(): string
    {
        return 'order_item';
    }
}
