<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM;

use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\AdminNote;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\AdminNoteAction;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\ApiKey;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\AttributeTaxonomy;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\DownloadableProductPermission;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\Log;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\OrderItem;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\OrderItemMeta;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\PaymentToken;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\PaymentTokenMeta;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\PostType\Product;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\PostType\ShopOrder;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\Session;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\ShippingZone;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\ShippingZoneMethods;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\TaxRate;
use WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity\TaxRateLocation;
use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;

class WooCommerceEntities
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('doctrine_entity_directories', $this->addEntityDirectories(...));
        add_filter('doctrine_post_type_discriminator_map', $this->addPostTypeDiscriminators(...));
        add_filter('doctrine_plugin_entity_table_prefixes', $this->setWoocommercePrefixes(...));
    }

    public function addEntityDirectories(array $directories): array
    {
        return [...$directories, realpath(__DIR__ . '/WooCommerceEntity')];
    }

    public function addPostTypeDiscriminators(array $classMap): array
    {
        return $classMap + [
                'product' => Product::class,
                'shop_order' => ShopOrder::class
            ];
    }

    /**
     * Set the prefixes for WooCommerce entities.
     *
     * @param array $classMap
     * @return array
     */
    public function setWoocommercePrefixes(array $classMap): array
    {
        $longPrefixEntities = [
            ApiKey::class,
            AttributeTaxonomy::class,
            DownloadableProductPermission::class,
            Log::class,
            OrderItem::class,
            OrderItemMeta::class,
            PaymentToken::class,
            PaymentTokenMeta::class,
            Session::class,
            ShippingZone::class,
            ShippingZoneMethods::class,
            TaxRate::class,
            TaxRateLocation::class
        ];
        foreach ($longPrefixEntities as $entityClass) {
            $classMap[$entityClass] = 'woocommerce';
        }

        $shortPrefixEntities = [
            AdminNote::class,
            AdminNoteAction::class,
        ];

        foreach ($shortPrefixEntities as $entityClass) {
            $classMap[$entityClass] = 'wc';
        }

        return $classMap;
    }

}
