<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\EntityTrait;

use DateTime;
use WRCE\Dependencies\Doctrine\ORM\Events;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Column;
use WRCE\Dependencies\Symfony\Component\Serializer\Annotation\Groups;
use WRCE\Dependencies\WordpressModels\ORM\Attributes\Timestamp;

trait Timestampable
{

    use SoftDeletable;

    #[Column(type: 'datetime')]
    #[Groups(['read_timestamps'])]
    #[Timestamp(Events::prePersist)]
    protected ?DateTime $createdAt = null;

    #[Column(type: 'datetime', nullable: true)]
    #[Groups(['read_timestamps'])]
    #[Timestamp(Events::preUpdate)]
    protected ?DateTime $updatedAt = null;

    /**
     * @return DateTime|null
     */
    public function getCreatedAt(): ?DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return DateTime|null
     */
    public function getUpdatedAt(): ?DateTime
    {
        return $this->updatedAt;
    }

    /**
     * @param DateTime|null $createdAt
     * @return self
     */
    public function setCreatedAt(?DateTime $createdAt): self
    {
        $this->createdAt = $createdAt;
        return $this;
    }

    /**
     * @param DateTime|null $updatedAt
     * @return self
     */
    public function setUpdatedAt(?DateTime $updatedAt): self
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }

}
