<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 18-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\Entity;

use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;
use WRCE\Dependencies\Symfony\Component\Serializer\Attribute\Context;
use WRCE\Dependencies\Symfony\Component\Serializer\Attribute\Groups;

/**
 * Entity mapping for the WordPress postmeta table
 *
 * This entity uses {@see AbstractMeta} as a base class for generic meta table mapping.
 */
#[
    ORM\Table('postmeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_postmeta'),
]
class PostMeta extends AbstractMeta
{

    #[ORM\ManyToOne(targetEntity: Post::class, inversedBy: 'meta'), ORM\JoinColumn('post_id', referencedColumnName: 'ID')]
    #[Context(normalizationContext: ['groups' => ['read_post']])]
    #[Groups(['read_meta_details', 'read_meta_post'])]
    private Post $post;

    public function getPost(): Post
    {
        return $this->post;
    }

    /**
     * @param Post $post
     */
    public function setPost(Post $post): void
    {
        $this->post = $post;
    }

    public static function getType(): string
    {
        return 'post';
    }

}
